// Images.h : Deklaration von CImages

#ifndef __IMAGES_H_
#define __IMAGES_H_

#include "resource.h"       // Hauptsymbole
#include "gd.h"
const int max_img=100;
/////////////////////////////////////////////////////////////////////////////
// CImages
class ATL_NO_VTABLE CImages : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CImages, &CLSID_Images>,
	public ISupportErrorInfo,
	public IDispatchImpl<IImages, &IID_IImages, &LIBID_GDIMAGELib>
{
public:
	CImages()
	{ for (int j=0; j<max_img; j++) img[j]=NULL;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_IMAGES)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CImages)
	COM_INTERFACE_ENTRY(IImages)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IImages
public:
	gdImagePtr img[max_img];
	STDMETHOD(ImageCreate)(/*[in]*/ int w, /*[in]*/ int h, /*[out][retval]*/ int * i);
	STDMETHOD(ImageCreateFromPng)(/*[in]*/ BSTR strFile, /*[out][retval]*/ int * i);
	STDMETHOD(ImageSX)(/*[in]*/ int i, /*[out][retval]*/ int * w);
	STDMETHOD(ImageSY)(/*[in]*/ int i, /*[out][retval]*/ int * h);
	STDMETHOD(ImageCopyResized)(/*[in]*/ int dst, /*[in]*/ int src, /*[in]*/ int dstX, /*[in]*/ int dstY, /*[in]*/ int srcX, /*[in]*/ int srcY, /*[in]*/ int destW, /*[in]*/ int destH, /*[in]*/ int srcW, /*[in]*/ int srcH);
	STDMETHOD(ImageDestroy)(/*[in]*/ int i);
	STDMETHOD(ImagePng)(/*[in]*/ int i, /*[in]*/ BSTR strFile);
	STDMETHOD(ImageColorExact)(/*[in]*/ int i, /*[in]*/ int r, /*[in]*/ int g, /*[in]*/ int b, /*[out][retval]*/ int * c);
	STDMETHOD(ImageColorAllocate)(/*[in]*/ int i, /*[in]*/ int r, /*[in]*/ int g, /*[in]*/ int b, /*[out][retval]*/ int * c);
	STDMETHOD(ImageColorClosest)(/*[in]*/ int i, /*[in]*/ int r, /*[in]*/ int g, /*[in]*/ int b, /*[out][retval]*/ int * c);
	STDMETHOD(ImageSetThickness)(/*[in]*/ int i, /*[in]*/ int t);
	STDMETHOD(ImageSetPixel)(/*[in]*/ int i, /*[in]*/ int x, /*[in]*/ int y, /*[in]*/ int color);
	STDMETHOD(ImageLine)(/*[in]*/ int i, /*[in]*/ int x1, /*[in]*/ int y1, /*[in]*/ int x2, /*[in]*/ int y2, /*[in]*/ int color);
	STDMETHOD(ImageRectangle)(/*[in]*/ int i, /*[in]*/ int x1, /*[in]*/ int y1, /*[in]*/ int x2, /*[in]*/ int y2, /*[in]*/ int color);
	STDMETHOD(ImageFilledRectangle)(/*[in]*/ int i, /*[in]*/ int x1, /*[in]*/ int y1, /*[in]*/ int x2, /*[in]*/ int y2, /*[in]*/ int color);
	STDMETHOD(ImagePolygon)(/*[in]*/ int i, /*[in]*/ VARIANT* p, /*[in]*/ int n, /*[in]*/ int color);
	STDMETHOD(ImageFilledPolygon)(/*[in]*/ int i, /*[in]*/ VARIANT* p, /*[in]*/ int n, /*[in]*/ int color);
	STDMETHOD(ImageArc)(/*[in]*/ int i, /*[in]*/ int cx, /*[in]*/ int cy, /*[in]*/ int w, /*[in]*/ int h, /*[in]*/ int s, /*[in]*/ int e, /*[in]*/ int color);
	STDMETHOD(ImageFilledArc)(/*[in]*/ int i, /*[in]*/ int cx, /*[in]*/ int cy, /*[in]*/ int w, /*[in]*/ int h, /*[in]*/ int s, /*[in]*/ int e, /*[in]*/ int color);
	STDMETHOD(ImageFilledEllipse)(/*[in]*/ int i, /*[in]*/ int cx, /*[in]*/ int cy, /*[in]*/ int w, /*[in]*/ int h, /*[in]*/ int color);
	STDMETHOD(ImageFontWidth)(/*[in]*/ int fs, /*[out][retval]*/ int * w);
	STDMETHOD(ImageFontHeight)(/*[in]*/ int fs, /*[out][retval]*/ int * h);
	STDMETHOD(ImageString)(/*[in]*/ int i, /*[in]*/ int fs, /*[in]*/ int x, /*[in]*/ int y, /*[in]*/ BSTR str, /*[in]*/ int color); 
	STDMETHOD(ImageStringUp)(/*[in]*/ int i, /*[in]*/ int fs, /*[in]*/ int x, /*[in]*/ int y, /*[in]*/ BSTR str, /*[in]*/ int color); 
};

#endif //__IMAGES_H_
