<%
' LT Diagram Builder 3.4 - VBScript version for ASP using gdImage.dll
' Copyright (c) 2001-2006 Lutz Tautenhahn, all rights reserved.
'
' The Author grants you a non-exclusive, royalty free, license to use,
' modify and redistribute this software, provided that this copyright notice
' and license appear on all copies of the software.
' This software is provided "as is", without a warranty of any kind.

Function UTC(yy,mm,dd,hh,nn,ss)
  Dim dd0, dd1
  dd0=DateSerial(1970,1,1)
  dd1=DateSerial(yy,mm,dd)
  dd1=DateAdd("h",hh,dd1)
  dd1=DateAdd("n",nn,dd1)
  dd1=DateAdd("s",ss,dd1)
  UTC=DateDiff("s", dd0, dd1)
End Function	

Function secTime(vv)
  Dim dd
  dd=DateSerial(1970,1,1)
  secTime=DateAdd("s",vv,dd)
End Function
	
Function Hex2Dec(cc)
  Select Case cc
    Case "a" Hex2Dec=10
    Case "b" Hex2Dec=11
    Case "c" Hex2Dec=12
    Case "d" Hex2Dec=13
    Case "e" Hex2Dec=14
    Case "f" Hex2Dec=15    
    Case Else Hex2Dec=CInt(cc)
  End Select
End Function

Sub HexToRGB(hh, rr, gg, bb)
  Dim tt
  tt=LCase(hh)
  if Len(tt)>6 then tt=Mid(tt,2,6)
  rr=Hex2Dec(Mid(tt,1,1))*16+Hex2Dec(Mid(tt,2,1))
  gg=Hex2Dec(Mid(tt,3,1))*16+Hex2Dec(Mid(tt,4,1))
  bb=Hex2Dec(Mid(tt,5,1))*16+Hex2Dec(Mid(tt,6,1))
End Sub 

Function sign(rr)
  if (rr<0) then
    sign=-1 
  else 
    sign=1
  end if
End Function

Function nvl(vv, rr)
  if (vv="") then 
    nvl=rr
  else 
    nvl=CStr(vv)
  end if  
End Function


Class Diagram

Public left
Public right
Public top
Public bottom
Public xmin
Public xmax
Public ymin
Public ymax
Public xtext
Public ytext
Public title
Public XScale
Public YScale
Public XScalePosition
Public YScalePosition
Public logsub
Public XGrid(3)
Public YGrid(3)
Public XGridDelta
Public YGridDelta
Public XSubGrids
Public YSubGrids
Public SubGrids
Public XGridColor
Public YGridColor
Public XSubGridColor
Public YSubGridColor
Public Font
Public BFont
Public MaxGrids
Public LastColor
Public LastImgColorIndex
Public ImgMapData
Public Img

Private Sub Class_Initialize()
  XScale=1
  YScale=1
  XScalePosition="bottom"
  YScalePosition="left"
  XGridDelta=0
  YGridDelta=0
  XSubGrids=0
  YSubGrids=0
  SubGrids=0
  XGridColor=""
  YGridColor=""
  XSubGridColor=""  
  YSubGridColor=""
  logsub=Array(0.301, 0.477, 0.602, 0.699, 0.778, 0.845, 0.903, 0.954)
  Font=4
  BFont=5
  LastColor=""
  LastImgColorIndex=0
  ImgMapData=""
  Img=NULL
End Sub  

Function GetImgColorIndex(theColor)
  if theColor=LastColor then
     GetImgColorIndex=LastImgColorIndex
     Exit Function
  end if
  Dim r, g, b
  HexToRGB theColor,r,g,b
  cc=Img.ImageColorExact(0, r, g, b)
  if cc<0 then cc = Img.ImageColorAllocate(0, r, g, b)
  if cc<0 then cc = Img.ImageColorClosest(0, r, g, b)
  LastColor=theColor
  LastImgColorIndex=cc
  GetImgColorIndex=cc
End Function

Public Sub SetFrame(theLeft, theTop, theRight, theBottom)
  left   = theLeft
  right  = theRight
  top    = theTop
  bottom = theBottom
End Sub

Public Sub SetBorder(theLeftX, theRightX, theBottomY, theTopY)
  xmin = theLeftX
  xmax = theRightX
  ymin = theBottomY
  ymax = theTopY
End Sub

Public Sub SetText(theScaleX, theScaleY, theTitle)
  xtext=theScaleX
  ytext=theScaleY
  title=theTitle
End Sub

Public Sub SetGridColor(theGridColor, theSubGridColor)
  XGridColor=theGridColor
  YGridColor=theGridColor
  XSubGridColor=theSubGridColor
  YSubGridColor=theSubGridColor
End Sub

Public Sub SetXGridColor(theGridColor, theSubGridColor)
  XGridColor=theGridColor
  XSubGridColor=theSubGridColor
End Sub

Public Sub SetYGridColor(theGridColor, theSubGridColor)
  YGridColor=theGridColor
  YSubGridColor=theSubGridColor
End Sub

Public Function ScreenX(theRealX)
  ScreenX=Round((theRealX-xmin)/(xmax-xmin)*(right-left)+left)
End Function

Public Function ScreenY(theRealY)
  ScreenY=Round((ymax-theRealY)/(ymax-ymin)*(bottom-top)+top)
End Function  

Public Function RealX(theScreenX)
  RealX=xmin+(xmax-xmin)*(theScreenX-left)/(right-left)
End Function

Public Function RealY(theScreenY)
  RealY=ymax-(ymax-ymin)*(theScreenY-top)/(bottom-top)
End Function


Public Function DateInterval(vv)
  Dim bb
  bb=140*24*60*60 '140 days
  SubGrids=4
  if (vv>=bb) then '140 days < 5 months
    bb=8766*60*60 '1 year
    if (vv<bb) then '1 year 
      DateInterval=bb/12 '1 month
      Exit Function
    end if  
    if (vv<bb*2) then '2 years 
      DateInterval=bb/6 '2 month
      Exit Function
    end if  
    if (vv<bb*5/2) then '2.5 years
      SubGrids=6
      DateInterval=bb/4 '3 month
      Exit Function
    end if  
    if (vv<bb*5) then '5 years
      SubGrids=6
      DateInterval=bb/2 '6 month
      Exit Function
    end if 
    if (vv<bb*10) then '10 years
      DateInterval=bb '1 year
      Exit Function
    end if
    if (vv<bb*20) then '20 years
      DateInterval=bb*2 '2 years
      Exit Function
    end if
    if (vv<bb*50) then '50 years
      SubGrids=5
      DateInterval=bb*5 '5 years
      Exit Function
    end if
    if (vv<bb*100) then '100 years
      SubGrids=5
      DateInterval=bb*10 '10 years
      Exit Function
    end if
    if (vv<bb*200) then '200 years
      DateInterval=bb*20 '20 years
      Exit Function
    end if
    if (vv<bb*500) then '500 years
      SubGrids=5
      DateInterval=bb*50 '50 years
      Exit Function
    end if
    SubGrids=5
    DateInterval=bb*100 '100 years
    Exit Function
  end if
  bb=bb/2 '70 days
  if (vv>=bb) then
    SubGrids=7
    DateInterval=bb/5 '14 days
    Exit Function
  end if
  bb=bb/2 '35 days
  if (vv>=bb) then
    SubGrids=7
    DateInterval=bb/5 '7 days
    Exit Function
  end if
  bb=bb/7
  bb=bb*4 '20 days
  if (vv>=bb) then
    DateInterval=bb/5 '4 days
    Exit Function
  end if
  bb=bb/2 '10 days
  if (vv>=bb) then
    DateInterval=bb/5 '2 days
    Exit Function
  end if
  bb=bb/2 '5 days
  if (vv>=bb) then 
    DateInterval=bb/5 '1 day
    Exit Function
  end if
  bb=bb/2 '2.5 days
  if (vv>=bb) then
    DateInterval=bb/5 '12 hours
    Exit Function
  end if
  bb=bb*3
  bb=bb/5 '1.5 day
  if (vv>=bb) then
    SubGrids=6
    DateInterval=bb/6 '6 hours
    Exit Function
  end if
  bb=bb/2 '18 hours
  if (vv>=bb) then
    SubGrids=6
    DateInterval=bb/6 '3 hours
    Exit Function
  end if
  bb=bb*2
  bb=bb/3 '12 hours
  if (vv>=bb) then
    DateInterval=bb/6 '2 hours
    Exit Function
  end if
  bb=bb/2 '6 hours
  if (vv>=bb) then
    DateInterval=bb/6 '1 hour
    Exit Function
  end if
  bb=bb/2 '3 hours
  if (vv>=bb) then 
    SubGrids=6
    DateInterval=bb/6 '30 mins
    Exit Function
  end if    
  bb=bb/2 '1.5 hours
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/6 '15 mins
    Exit Function
  end if
  bb=bb*2
  bb=bb/3 '1 hour
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/6 '10 mins
    Exit Function
  end if
  bb=bb/3 '20 mins
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/4 '5 mins
    Exit Function
  end if    
  bb=bb/2 '10 mins
  if (vv>=bb) then
    DateInterval=bb/5 '2 mins
    Exit Function
  end if
  bb=bb/2 '5 mins
  if (vv>=bb) then
    DateInterval=bb/5 '1 min
    Exit Function
  end if
  bb=bb*3
  bb=bb/2 '3 mins
  if (vv>=bb) then
    SubGrids=6
    DateInterval=bb/6 '30 secs
    Exit Function
  end if
  bb=bb/2 '1.5 mins
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/6 '15 secs
    Exit Function
  end if
  bb=bb*2
  bb=bb/3 '1 min
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/6 '10 secs
    Exit Function
  end if
  bb=bb/3 '20 secs
  if (vv>=bb) then
    SubGrids=5
    DateInterval=bb/4 '5 secs
    Exit Function
  end if
  bb=bb/2 '10 secs
  if (vv>=bb) then
    DateInterval=bb/5 '2 secs
    Exit Function
  end if
  DateInterval=bb/10 '1 sec
end Function

Public Function DateFormat(vv, ii, ttype)
  Dim yy, mm, dd, hh, nn, ss, vv_date, AMonth, AWeekday
  vv_date=secTime(vv)
  AMonth=Array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")
  AWeekday=Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat")
  if (ii>15*24*60*60) then
    if (ii<365*24*60*60) then
      vv_date=secTime(vv+15*24*60*60)
      yy=CStr(DatePart("yyyy",vv_date) Mod 100)
      if (len(yy)<2) then yy="0" & CStr(yy)
      mm=DatePart("m",vv_date)
      DateFormat=CStr(mm)&"/"&yy
      'if (ttype=5) 'You can add your own date format here
      if (ttype=4) then DateFormat=AMonth(mm-1)
      if (ttype=3) then DateFormat=AMonth(mm-1)&" "&yy
      Exit Function
    end if
    vv_date=secTime(vv+183*24*60*60)
    yy=DatePart("yyyy",vv_date)
    DateFormat=yy
    Exit Function
  end if
  vv_date=secTime(vv)
  yy=CStr(DatePart("YYYY",vv_date))
  mm=DatePart("m",vv_date)
  dd=DatePart("d",vv_date)
  ww=DatePart("w",vv_date)
  hh=DatePart("h",vv_date)
  nn=DatePart("n",vv_date)
  ss=DatePart("s",vv_date)
  if (ii>=86400) then '1 day
    DateFormat=CStr(dd)&"."&CStr(mm)&"."
    'if (ttype=5) 'You can add your own date format here
    if (ttype=4) then DateFormat=AWeekday(ww-1)
    if (ttype=3) then DateFormat=CStr(mm)&"/"&CStr(dd)
    Exit Function
  end if
  if (ii>=21600) then '6 hours 
    if (hh=0) then 
      DateFormat=CStr(dd)&"."&CStr(mm)&"."
      'if (ttype=5) 'You can add your own date format here
      if (ttype=4) then DateFormat=AWeekday(ww-1)
      if (ttype=3) then DateFormat=CStr(mm)&"/"&CStr(dd)
      Exit Function
    else
      DateFormat=CStr(hh)&":00"
      'if (ttype=5) 'You can add your own date format here
      if (ttype=4) then
        if (hh<=12) then 
          DateFormat=CStr(hh)&"am"
        else
          DateFormat=CStr(hh Mod 12)&"pm"
        end if  
      end if
      if (ttype=3) then
        if (hh<=12) then 
          DateFormat=CStr(hh)&"am"
        else
          DateFormat=CStr(hh Mod 12)&"pm"
        end if  
      end if
      Exit Function
    end if
  end if
  if (ii>=60) then '1 min
    if (nn<10) then nn="0"&CStr(nn)
    DateFormat=CStr(hh)&":"&CStr(nn)
    'if (ttype=5) 'You can add your own date format here
    if (ttype=4) then
      if (hh<=12) then
        DateFormat=CStr(hh)&"."&CStr(nn)&"am" 
      else
        DateFormat=CStr(hh Mod 12)&"."&CStr(nn)&"pm"
      end if  
    end if
    if (nn="00") then
      nn=""
    else 
      nn=":"+CStr(nn)
    end if  
    if (ttype=3) then
      if (hh<=12) then
        DateFormat=CStr(hh)&CStr(nn)&"am"
      else
        DateFormat=CStr(hh Mod 12)&CStr(nn)&"pm"
      end if
    end if  
    Exit Function
  end if
  if (ss<10) then ss="0"&CStr(ss)
  DateFormat=CStr(nn)&":"&CStr(ss)
End Function

Public Function GetXGrid()
  Dim x0, i, j, l, x, r, dx, xr, invdifx, deltax
  dx=(xmax-xmin)
  if (Abs(dx)>0) then
    invdifx=(right-left)/(xmax-xmin)
    if ((CStr(XScale)="1") or (not IsNumeric(XScale))) then
      r=1
      do while (Abs(dx)>=100) 
        dx=dx/10
        r=r*10
      loop  
      do while (Abs(dx)<10)
        dx=dx*10
        r=r/10
      loop  
      if (Abs(dx)>=50) then
        SubGrids=5
        deltax=10*r*sign(dx)
      else
        if (Abs(dx)>=20) then
          SubGrids=5
          deltax=5*r*sign(dx)
        else 
          SubGrids=4
          deltax=2*r*sign(dx)
        end if
      end if
    else 
      deltax=DateInterval(Abs(dx))*sign(dx)
    end if  
    if (XGridDelta<>0) then deltax=XGridDelta
    if (XSubGrids<>0) then SubGrids=XSubGrids
    x=Int(xmin/deltax)*deltax
    i=0
    XGrid(1)=deltax
    MaxGrids=0
    if deltax<>0 then MaxGrids=Int(Abs((xmax-xmin)/deltax))+2
    for j=MaxGrids to -1 Step -1
      xr=x+j*deltax
      x0=Round(left+(-xmin+xr)*invdifx)
      if ((x0>=left) And (x0<=right)) then
        if (i=0) then XGrid(2)=xr
        XGrid(0)=xr
        i=i+1
      end if
    next
  end if
  GetXGrid=XGrid
End Function

Public Function GetYGrid()
  Dim y0, i, j, l, y, r, dy, yr, invdify, deltay
  dy=ymax-ymin
  if (Abs(dy)>0) then
    invdify=(bottom-top)/(ymax-ymin)
    if ((CStr(YScale)="1") or (not IsNumeric(YScale))) then
      r=1
      do while (Abs(dy)>=100)
         dy=dy/10
         r=r*10
      loop   
      do while (Abs(dy)<10)
        dy=dy*10
        r=r/10
      loop  
      if (Abs(dy)>=50) then
        SubGrids=5
        deltay=10*r*sign(dy)
      else
        if (Abs(dy)>=20) then
          SubGrids=5
          deltay=5*r*sign(dy)
        else
          SubGrids=4
          deltay=2*r*sign(dy)
        end if
      end if
    else 
      deltay=DateInterval(Abs(dy))*sign(dy)
    end if  
    if (YGridDelta<>0) then deltay=YGridDelta
    if (YSubGrids<>0) then SubGrids=YSubGrids
    y=Int(ymax/deltay)*deltay
    YGrid(1)=deltay
    i=0
    MaxGrids=0
    if deltay<>0 then MaxGrids=Int(Abs((ymax-ymin)/deltay))+2
    for j=-1 to MaxGrids
      yr=y-j*deltay
      y0=Round(top+(ymax-yr)*invdify)
      if ((y0>=top) And (y0<=bottom)) then
        if (i=0) then YGrid(2)=yr
        YGrid(0)=yr
        i=i+1
      end if
    next
  end if
  GetYGrid=YGrid
End Function

Public Sub Draw(theDrawColor, theTextColor, isScaleText, theToolTipText, theEventActions)
  Dim x0, y0, i, j, itext, l, x, y, r, u, fn, dx, dy, xr, yr, invdifx, invdify, deltax, deltay, ii, oo, k, ssub, dd, hh
  Dim ccDraw, ccText, ccGridX, ccSubGridX, ccGridY, ccSubGridY, ff, ww, sshift
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  if (theDrawColor<>"") then
    if Mid(LCase(theDrawColor),Len(theDrawColor)-3,4)=".png" then 
      ff=theDrawColor
      if isObject(Server) then ff=Server.mappath(ff)       
      ii=Img.ImageCreateFromPng(ff)
      if ii>0 then
        ww = Img.ImageSX(ii)
        hh = Img.ImageSY(ii)
        Img.ImageCopyResized 0, ii, left, top, 0, 0, right-left+1, bottom-top+1, ww, hh
        Img.ImageDestroy ii
      end if  
    else 
      ccDraw=GetImgColorIndex(theDrawColor)
      Img.ImageFilledRectangle 0, left, top, right, bottom, ccDraw
    end if    	
  end if
  
  ccText=GetImgColorIndex(theTextColor)
  if (XGridColor<>"") then ccGridX=GetImgColorIndex(XGridColor)
  if (XSubGridColor<>"") then ccSubGridX=GetImgColorIndex(XSubGridColor)
  if (YGridColor<>"") then ccGridY=GetImgColorIndex(YGridColor)
  if (YSubGridColor<>"") then ccSubGridY=GetImgColorIndex(YSubGridColor)

  if (CStr(XScale)="1") or (not IsNumeric(XScale)) then
    u=""
    fn=""
    if (not IsNumeric(XScale)) then
      if (Mid(XScale,1,9)="function ") then 
        fn=Mid(XScale,10,100)
      else 
        u=XScale
      end if
    end if
    dx=(xmax-xmin)
    if (Abs(dx)>0) then
      invdifx=(right-left)/(xmax-xmin)
      r=1
      do while (Abs(dx)>=100)
        dx=dx/10
        r=r*10
      loop  
      do while (Abs(dx)<10)
        dx=dx*10
        r=r/10
      loop  
      if (Abs(dx)>=50) then
        SubGrids=5
        deltax=10*r*sign(dx)  
      else
        if (Abs(dx)>=20) then
          SubGrids=5
          deltax=5*r*sign(dx)
        else 
          SubGrids=4
          deltax=2*r*sign(dx)
        end if  
      end if
      if (XGridDelta<>0) then deltax=XGridDelta
      if (XSubGrids<>0) then SubGrids=XSubGrids
      ssub=deltax*invdifx/SubGrids
      sshift=0
      if (XScalePosition="top-left") or (XScalePosition="bottom-left") then sshift=-Abs(deltax*invdifx/2)
      if (XScalePosition="top-right") or (XScalePosition="bottom-right") then sshift=Abs(deltax*invdifx/2)
      x=Int(xmin/deltax)*deltax
      itext=0
      MaxGrids=0
      if deltax<>0 then MaxGrids=Int(Abs((xmax-xmin)/deltax))+2
      for j=MaxGrids to -1 Step -1
        xr=x+j*deltax
        x0=Round(left+(-xmin+xr)*invdifx)
        if (XSubGridColor<>"") then
          for k=1 to SubGrids-1
            if ((x0-k*ssub>left+1) And (x0-k*ssub<right-1)) then
              ii=Round(x0-k*ssub)
              Img.ImageLine 0, ii,top,ii,bottom,ccSubGridX
            end if  
          next
          if SubGrids=-1 then
            for k=0 to 7
              if ((x0-logsub(k)*ssub*sign(deltax)>left+1) And (x0-logsub(k)*ssub*sign(deltax)<right-1)) then
                ii=Round(x0-logsub(k)*ssub*sign(deltax))
                Img.ImageLine 0, ii,top,ii,bottom,ccSubGridX
              end if
            next
          end if
        end if
        if ((x0>=left) And (x0<=right)) then
          itext=itext+1
          if ((itext<>2) or (not isScaleText)) then
            if (r>1) then 
              if (fn<>"") then
                l=CStr(eval(fn&"("&""""&CStr(xr)&""""&")"))
              else 
                l=CStr(xr)&u
              end if   
            else 
              if (fn<>"") then
                l=CStr(eval(fn&"("&""""&CStr(Round(10*xr/r)/Round(10/r))&""""&")"))
              else 
                l=CStr(Round(10*xr/r)/Round(10/r))&u 
              end if  
            end if
            if (Mid(l,1,1)=".") then l="0"&l
            if (Mid(l,1,2)="-.") then l="-0"+Mid(l,2,100)
          else 
            l=xtext
          end if  
          dd = Img.ImageFontWidth(Abs(Font))*Len(l)
          hh = Img.ImageFontHeight(Abs(Font))
          if (Mid(XScalePosition,1,3)<>"top") then
            if ((x0+sshift>=left) And (x0+sshift<=right)) then
              if (Font>=0) then 
                Img.ImageString 0, Font, x0-dd/2+sshift, bottom+8, l, ccText
              else
                Img.ImageStringUp 0, -Font, x0-hh/2+sshift, bottom+9+dd, l, ccText
              end if  
            end if
            Img.ImageLine 0, x0,bottom-5,x0,bottom+6, ccText
          else
            if ((x0+sshift>=left) And (x0+sshift<=right)) then
              if (Font>=0) then 	
                Img.ImageString 0, Font, x0-dd/2, top-6-hh, l, ccText
              else
                Img.ImageStringUp 0, -Font, x0-hh/2+sshift, top-9, l, ccText
              end if  
            end if
            Img.ImageLine 0, x0,top-5,x0,top+6, ccText
          end if
          if ((XGridColor<>"") And (x0>left) And (x0<right)) then
            Img.ImageLine 0, x0,top,x0,bottom,ccGridX 
          end if
        end if
      next
    end if
  end if
  if ((IsNumeric(XScale)) And (XScale>"1")) then
    dx=(xmax-xmin)
    if (Abs(dx)>0) then
      invdifx=(right-left)/(xmax-xmin)
      deltax=DateInterval(Abs(dx))*sign(dx)
      if (XGridDelta<>0) then deltax=XGridDelta
      if (XSubGrids<>0) then SubGrids=XSubGrids
      ssub=deltax*invdifx/SubGrids
      sshift=0
      if (XScalePosition="top-left") or (XScalePosition="bottom-left") then sshift=-Abs(deltax*invdifx/2)
      if (XScalePosition="top-right") or (XScalePosition="bottom-right") then sshift=Abs(deltax*invdifx/2)       
      x=Int(xmin/deltax)*deltax
      itext=0
      MaxGrids=0
      if deltax<>0 then MaxGrids=Int(Abs((xmax-xmin)/deltax))+2
      for j=MaxGrids to -2 Step -1
        xr=x+j*deltax
        x0=Round(left+(-xmin+x+j*deltax)*invdifx)
        if (XSubGridColor<>"") then
          for k=1 to SubGrids-1
            if ((x0-k*ssub>left+1) And (x0-k*ssub<right-1)) then
              ii=Round(x0-k*ssub)
              Img.ImageLine 0, ii,top,ii,bottom,ccSubGridX
            end if  
          next
        end if
        if ((x0>=left) And (x0<=right)) then
          itext=itext+1
          if ((itext<>2) or (not isScaleText)) then
            l=DateFormat(xr, Abs(deltax), XScale)
          else 
            l=xtext
          end if
          dd = Img.ImageFontWidth(Abs(Font))*Len(l)
          hh = Img.ImageFontHeight(Abs(Font))
          if (Mid(XScalePosition,1,3)<>"top") then
            if ((x0+sshift>=left) And (x0+sshift<=right)) then
              if (Font>=0) then 
                Img.ImageString 0, Font, x0-dd/2+sshift, bottom+8, l, ccText
              else
                Img.ImageStringUp 0, -Font, x0-hh/2+sshift, bottom+9+dd, l, ccText
              end if  
            end if
            Img.ImageLine 0, x0,bottom-5,x0,bottom+6, ccText
          else
            if ((x0+sshift>=left) And (x0+sshift<=right)) then
              if (Font>=0) then 	
                Img.ImageString 0, Font, x0-dd/2, top-6-hh, l, ccText
              else
                Img.ImageStringUp 0, -Font, x0-hh/2+sshift, top-9, l, ccText
              end if  
            end if
            Img.ImageLine 0, x0,top-5,x0,top+6, ccText
          end if          
          if ((XGridColor<>"") And (x0>left) And (x0<right)) then
            Img.ImageLine 0, x0,top,x0,bottom,ccGridX 
          end if
        end if
      next
    end if
  end if  
  if ((CStr(YScale)="1") or (not IsNumeric(YScale))) then
    u=""
    fn=""
    if (not IsNumeric(YScale)) then
      if (Mid(YScale,1,9)="function ") then 
        fn=Mid(YScale,10,100)
      else 
        u=YScale
      end if
    end if
    dy=ymax-ymin
    if (Abs(dy)>0) then
      invdify=(bottom-top)/(ymax-ymin)
      r=1
      do while (Abs(dy)>=100)
        dy=dy/10
        r=r*10
      loop  
      do while (Abs(dy)<10)
        dy=dy*10
        r=r/10
      loop  
      if (Abs(dy)>=50) then
        SubGrids=5
        deltay=10*r*sign(dy)
      else
        if (Abs(dy)>=20) then
          SubGrids=5
          deltay=5*r*sign(dy)          
        else
          SubGrids=4
          deltay=2*r*sign(dy)
        end if
      end if     
      if (YGridDelta<>0) then deltay=YGridDelta
      if (YSubGrids<>0) then SubGrids=YSubGrids
      ssub=deltay*invdify/SubGrids
      sshift=0
      if (YScalePosition="left-top") or (YScalePosition="right-top") then sshift=-Abs(deltay*invdify/2)
      if (YScalePosition="left-bottom") or (YScalePosition="right-bottom") then sshift=Abs(deltay*invdify/2)
      y=Int(ymax/deltay)*deltay
      itext=0
      MaxGrids=0
      if deltay<>0 then MaxGrids=Int(Abs((ymax-ymin)/deltay))+2
      for j=-1 to MaxGrids
        yr=y-j*deltay
        y0=Round(top+(ymax-yr)*invdify)
        if (YSubGridColor<>"") then
          for k=1 to SubGrids-1
            if ((y0+k*ssub>top+1) And (y0+k*ssub<bottom-1)) then
              ii=Round(y0+k*ssub)
              Img.ImageLine 0, left,ii,right,ii,ccSubGridY
            end if  
          next
          if SubGrids=-1 then
            for k=0 to 7
              if ((y0+logsub(k)*ssub*sign(deltay)>top+1) And (y0+logsub(k)*ssub*sign(deltay)<bottom-1)) then
                ii=Round(y0+logsub(k)*ssub*sign(deltay))
                Img.ImageLine 0, left,ii,right,ii,ccSubGridY
              end if
            next
          end if
        end if
        if ((y0>=top) And (y0<=bottom)) then
          itext=itext+1
          if ((itext<>2) or (not isScaleText)) then
            if (r>1) then
              if (fn<>"") then
                l=CStr(eval(fn&"("&""""&CStr(yr)&""""&")"))
              else 
                l=CStr(yr)&u
              end if
            else
              if (fn<>"") then
                l=CStr(eval(fn&"("&""""&CStr(Round(10*yr/r)/Round(10/r))&""""&")"))
              else 
                l=CStr(Round(10*yr/r)/Round(10/r))&u 
              end if  
            end if
            if (Mid(l,1,1)=".") then l="0"&l
            if (Mid(l,1,2)="-.") then l="-0"+Mid(l,2,100)
          else 
            l=ytext
          end if
          dd = Img.ImageFontWidth(Abs(Font))*Len(l)
          hh = Img.ImageFontHeight(Abs(Font))
          if (Mid(YScalePosition,1,5)<>"right") then
            if ((y0+sshift>=top) And (y0+sshift<=bottom)) then
              Img.ImageString 0, Abs(Font), left-dd-10, y0-hh/2+sshift, l, ccText
            end if  
            Img.ImageLine 0, left-5,y0,left+5,y0, ccText
          else
            if ((y0+sshift>=top) And (y0+sshift<=bottom)) then
              Img.ImageString 0, Abs(Font), right+10, y0-hh/2+sshift, l, ccText
            end if
            Img.ImageLine 0, right-5,y0,right+5,y0, ccText
          end if
          if ((YGridColor<>"") And (y0>top) And (y0<bottom)) then
            Img.ImageLine 0, left,y0,right,y0,ccGridY 
          end if
        end if
      next
    end if
  end if
  if ((IsNumeric(YScale)) And (YScale>"1")) then
    dy=ymax-ymin
    if (Abs(dy)>0) then
      invdify=(bottom-top)/(ymax-ymin)
      deltay=DateInterval(Abs(dy))*sign(dy)
      if (YGridDelta<>0) then deltay=YGridDelta
      if (YSubGrids<>0) then SubGrids=YSubGrids
      ssub=deltay*invdify/SubGrids
      sshift=0
      if (YScalePosition="left-top") or (YScalePosition="right-top") then sshift=-Abs(deltay*invdify/2)
      if (YScalePosition="left-bottom") or (YScalePosition="right-bottom") then sshift=Abs(deltay*invdify/2)      
      y=Int(ymax/deltay)*deltay
      itext=0
      MaxGrids=0
      if deltay<>0 then MaxGrids=Int(Abs((ymax-ymin)/deltay))+2
      for j=-2 to MaxGrids
        yr=y-j*deltay
        y0=Round(top+(ymax-y+j*deltay)*invdify)
        if (YSubGridColor<>"") then
          for k=1 to SubGrids-1
            if ((y0+k*ssub>top+1) And (y0+k*ssub<bottom-1)) then
              ii=Round(y0+k*ssub)
              Img.ImageLine 0, left,ii,right,ii,ccSubGridY
            end if  
          next
        end if
        if ((y0>=top) And (y0<=bottom)) then
          itext=itext+1
          if ((itext<>2) or (not isScaleText)) then
            l=DateFormat(yr, Abs(deltay), YScale)
          else 
            l=ytext
          end if
          dd = Img.ImageFontWidth(Abs(Font))*Len(l)
          hh = Img.ImageFontHeight(Abs(Font))
          if (Mid(YScalePosition,1,5)<>"right") then
            if ((y0+sshift>=top) And (y0+sshift<=bottom)) then
              Img.ImageString 0, Abs(Font), left-dd-10, y0-hh/2+sshift, l, ccText
            end if  
            Img.ImageLine 0, left-5,y0,left+5,y0, ccText
          else
            if ((y0+sshift>=top) And (y0+sshift<=bottom)) then
              Img.ImageString 0, Abs(Font), right+10, y0-hh/2+sshift, l, ccText
            end if
            Img.ImageLine 0, right-5,y0,right+5,y0, ccText
          end if
          if ((YGridColor<>"") And (y0>top) And (y0<bottom)) then
            Img.ImageLine 0, left,y0,right,y0,ccGridY 
          end if
        end if
      next
    end if
  end if
  Img.ImageRectangle 0, left, top, right, bottom, ccText
  if title<>"" then  
    dd=Img.ImageFontWidth(Abs(Font))*Len(title)
    hh=Img.ImageFontHeight(Abs(Font))
    if (Mid(XScalePosition,1,3)<>"top") then
      Img.ImageString 0, Abs(Font), (left+right-dd)/2, top-hh-4, title, ccText
    else
      Img.ImageString 0, Abs(Font), (left+right-dd)/2, bottom+4, title, ccText
    end if  	  
  end if
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=rect coords='" & left & "," & top & "," & right & "," & bottom & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if
End Sub

Public Sub Bar(theLeft, theTop, theRight, theBottom, theDrawColor, theText, theTextColor, theTooltipText, theEventActions)
  Dim cc, dd, ll, rr, tt, bb, ww, hh, ff
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  if theText<>"" then
    dd = Img.ImageFontWidth(Abs(BFont))*Len(theText)-2
  else
    dd=0
  end if  
  ll=theLeft
  rr=theRight
  tt=theTop
  bb=theBottom
  if BFont>0 then
    if ll="" And rr<>"" then ll=rr-dd-2
    if rr="" And ll<>"" then rr=ll+dd+2
    if tt="" And bb<>"" then tt=bb-12-BFont
    if bb="" And tt<>"" then bb=tt+12+BFont
  else
    if ll="" And rr<>"" then ll=rr-12+BFont
    if rr="" And ll<>"" then rr=ll+12-BFont
    if tt="" And bb<>"" then tt=bb-dd-2
    if bb="" And tt<>"" then bb=tt+dd+2
  end if
  if (theDrawColor<>"") then
    if Mid(LCase(theDrawColor),Len(theDrawColor)-3,4)=".png" then 
      ff=theDrawColor
      if isObject(Server) then ff=Server.mappath(ff)       
      ii=Img.ImageCreateFromPng(ff)
      if ii>0 then
        ww = Img.ImageSX(ii)
        hh = Img.ImageSY(ii)
        Img.ImageCopyResized 0, ii, ll, tt, 0, 0, rr-ll+1, bb-tt+1, ww, hh
        Img.ImageDestroy ii
      end if  
    else 
      cc=GetImgColorIndex(theDrawColor)
      Img.ImageFilledRectangle 0, ll, tt, rr, bb, cc
    end if  
  end if
  if (theText<>"") then
    cc=GetImgColorIndex(theTextColor)
    if BFont>0 then
      Img.ImageString 0, BFont, (ll+rr-dd)/2, tt+1, theText, cc   
    else
      Img.ImageStringUp 0, -BFont, ll+1, (tt+bb+dd)/2, theText, cc       
    end if
  end if
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=rect coords='" & ll & "," & tt & "," & rr & "," & bb & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if
End Sub

Public Sub Box(theLeft, theTop, theRight, theBottom, theDrawColor, theText, theTextColor, theBorderWidth, theBorderColor, theTooltipText, theEventActions)
  Dim cc, dd, ll, rr, tt, bb, ww, hh, ff
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  if theText<>"" then
    dd = Img.ImageFontWidth(Abs(BFont))*Len(theText)-2
  else
    dd=0
  end if  
  ll=theLeft
  rr=theRight
  tt=theTop
  bb=theBottom
  if BFont>0 then
    if ll="" And rr<>"" then ll=rr-dd-2-2*theBorderWidth
    if rr="" And ll<>"" then rr=ll+dd+2+2*theBorderWidth  
    if tt="" And bb<>"" then tt=bb-12-BFont-2*theBorderWidth
    if bb="" And tt<>"" then bb=tt+12+BFont+2*theBorderWidth  
  else
    if ll="" And rr<>"" then ll=rr-12+BFont-2*theBorderWidth
    if rr="" And ll<>"" then rr=ll+12-BFont+2*theBorderWidth  
    if tt="" And bb<>"" then tt=bb-dd-2-2*theBorderWidth
    if bb="" And tt<>"" then bb=tt+dd+2+2*theBorderWidth  
  end if
  if (theDrawColor<>"") then
    if Mid(LCase(theDrawColor),Len(theDrawColor)-3,4)=".png" then
      ff=theDrawColor
      if isObject(Server) then ff=Server.mappath(ff)       
      ii=Img.ImageCreateFromPng(ff)
      if ii>0 then
        ww = Img.ImageSX(ii)
        hh = Img.ImageSY(ii)
        Img.ImageCopyResized 0, ii, ll, tt, 0, 0, rr-ll+1, bb-tt+1, ww, hh
        Img.ImageDestroy ii
      end if  
    else 
      cc=GetImgColorIndex(theDrawColor)
      Img.ImageFilledRectangle 0, ll, tt, rr, bb, cc
    end if  
  end if
  if (theBorderColor<>"") then
    cc=GetImgColorIndex(theBorderColor)
    Img.ImageSetThickness 0, theBorderWidth
    Img.ImageRectangle 0, ll, tt, rr, bb, cc
    Img.ImageSetThickness 0, 1  
  end if  
  if (theText<>"") then
    cc=GetImgColorIndex(theTextColor)
    if BFont>0 then
      Img.ImageString 0, BFont, (ll+rr-dd)/2, tt+theBorderWidth+1, theText, cc   
    else
      Img.ImageStringUp 0, -BFont, ll+theBorderWidth+1, (tt+bb+dd)/2, theText, cc       
    end if   
  end if
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=rect coords='" & ll & "," & tt & "," & rr & "," & bb & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if  
End Sub

Public Sub Dot(theX, theY, theSize, theType, theColor, theTooltipText, theEventActions)
  Dim cc, ww, hh, ff
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  if not IsNumeric(theType) then
    if Mid(LCase(theType),Len(theType)-3,4)=".png" then
      ff=theType
      if isObject(Server) then ff=Server.mappath(ff)       
      ii=Img.ImageCreateFromPng(ff)    
      if ii>0 then
        ww = Img.ImageSX(ii)
        hh = Img.ImageSY(ii)
        Img.ImageCopyResized 0, ii, theX-theSize/2+1, theY-theSize/2+1, 0, 0, theSize, theSize, ww, hh
        Img.ImageDestroy ii
      end if  
    end if
  else
    cc=GetImgColorIndex(theColor)
    if (theType Mod 6=0) then
      Img.ImageFilledEllipse 0, theX, theY, theSize, theSize, cc 
    end if
    if (theType Mod 6=1) then
      Img.ImageSetThickness 0, Round(theSize/4)
      Img.ImageLine 0, theX+theSize\2-theSize, theY, theX+theSize\2, theY, cc
      Img.ImageLine 0, theX, theY+theSize\2-theSize, theX, theY+theSize\2, cc
      Img.ImageSetThickness 0, 1  
    end if
    if (theType Mod 6=2) then
      Img.ImageFilledRectangle 0, theX+theSize\2-theSize, theY+theSize\2-theSize, theX+theSize\2, theY+theSize\2, cc
    end if
    if (theType Mod 6=3) then
      Img.ImageSetThickness 0, Round(theSize/4)
      Img.ImageLine 0, theX-theSize\2, theY+theSize-theSize\2, theX, theY-theSize\2, cc
      Img.ImageLine 0, theX, theY-theSize\2, theX+theSize-theSize\2, theY+theSize-theSize\2, cc
      Img.ImageLine 0, theX-theSize\2, theY+theSize-theSize\2-theSize\7+1,theX+theSize-theSize\2, theY+theSize-theSize\2-theSize\7+1, cc
      Img.ImageSetThickness 0, 1  
    end if
    if (theType Mod 6=4) then
      Img.ImageSetThickness 0, Round(theSize/4) 
      Img.ImageLine 0, theX-theSize\2, theY-theSize\2, theX, theY+theSize-theSize\2, cc
      Img.ImageLine 0, theX, theY+theSize-theSize\2, theX+theSize-theSize\2, theY-theSize\2, cc
      Img.ImageLine 0, theX-theSize\2, theY-theSize\2+theSize\7,theX+theSize-theSize\2, theY-theSize\2+theSize\7, cc
      Img.ImageSetThickness 0, 1  
    end if
    if (theType Mod 6=5) then
      Img.ImageSetThickness 0, Round(theSize/4)
      Img.ImageRectangle 0, theX+theSize\2-theSize, theY+theSize\2-theSize, theX+theSize\2, theY+theSize\2, cc
      Img.ImageSetThickness 0, 1  
    end if
  end if
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=circle coords='" & theX & "," & theY & "," & Round(theSize/2) & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if    
End Sub

Public Sub Pixel(theX, theY, theColor)
  Dim cc
  cc=GetImgColorIndex(theColor)
  Img.ImageSetPixel 0, theX, theY, cc
End Sub

Public Sub Line(theX0, theY0, theX1, theY1, theColor, theSize, theTooltipText, theEventActions)
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  Dim cc
  cc=GetImgColorIndex(theColor)
  if theSize<>"" then Img.ImageSetThickness 0, 2*theSize-1
  Img.ImageLine 0, theX0, theY0, theX1, theY1, cc
  Img.ImageSetThickness 0, 1
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    LL=1
    DDX=theX1-theX0
    DDY=theY1-theY0
    if DDX<>0 or DDY<>0 then LL=sqr((DDX*DDX)+(DDY*DDY))
    tmpMapData="<area shape=polygon coords='" & Round(theX0+(theSize+1)*DDY/LL) & "," & Round(theY0-(theSize+1)*DDX/LL) & "," & Round(theX1+(theSize+1)*DDY/LL) & "," & Round(theY1-(theSize+1)*DDX/LL) & "," & Round(theX1-(theSize+1)*DDY/LL) & "," & Round(theY1+(theSize+1)*DDX/LL) & "," & Round(theX0-(theSize+1)*DDY/LL) & "," & Round(theY0+(theSize+1)*DDX/LL) & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if  
End Sub

Public Sub Area(theX0, theY0, theX1, theY1, theColor, theBase, theTooltipText, theEventActions)
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  Dim cc
  cc=GetImgColorIndex(theColor)
  Dim pp(8)
  pp(0) = CInt(theX0)
  pp(1) = CInt(theBase)
  pp(2) = CInt(theX0)
  pp(3) = CInt(theY0)
  pp(4) = CInt(theX1)
  pp(5) = CInt(theY1)
  pp(6) = CInt(theX1)
  pp(7) = CInt(theBase+1)
  Img.ImageFilledPolygon 0, pp, 4, cc
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=polygon coords='" & theX0 & "," & theBase & "," & theX0 & "," & theY0 & "," & theX1 & "," & theY1 & "," & theX1 & "," & theBase & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if
End Sub

Public Sub Arrow(theX0, theY0, theX1, theY1, theColor, theSize, theTooltipText, theEventActions)
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  Dim cc, LL, ccL, ccB, DDX, DDY
  cc=GetImgColorIndex(theColor)
  LL=1
  ccL=6*theSize+8
  ccB=2*theSize+2
  DDX=theX1-theX0
  DDY=theY1-theY0
  if DDX<>0 or DDY<>0 then LL=sqr((DDX*DDX)+(DDY*DDY))
  Dim pp(6)
  pp(0) = CInt(theX1-Round((ccL*DDX+ccB*DDY)/LL))
  pp(1) = CInt(theY1-Round((ccL*DDY-ccB*DDX)/LL))
  pp(2) = CInt(theX1)
  pp(3) = CInt(theY1)
  pp(4) = CInt(theX1-Round((ccL*DDX-ccB*DDY)/LL))
  pp(5) = CInt(theY1-Round((ccL*DDY+ccB*DDX)/LL))
  Img.ImageFilledPolygon 0, pp, 3 , cc 
  Img.ImageSetThickness 0, 2*theSize-1
  Img.ImageLine 0, theX0,theY0,(pp(0)+pp(2)+pp(4))/3,(pp(1)+pp(3)+pp(5))/3,cc
  Img.ImageSetThickness 0, 1
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    tmpMapData="<area shape=polygon coords='" & _
      pp(2) & "," & pp(3) & "," & pp(4) & "," & pp(5) & "," & pp(0) & "," & pp(1) & "," & pp(2) & "," & pp(3) & "," & _
      Round(theX0-theSize*DDY/LL) & "," & Round(theY0+theSize*DDX/LL) & "," & _
      Round(theX0+theSize*DDY/LL) & "," & Round(theY0-theSize*DDX/LL) & "' "
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if  
End Sub

Public Sub Pie(theXCenter, theYCenter, theOffset, theRadius, theAngle0, theAngle1, theColor, theTooltipText, theEventActions)
  Dim theOnClickAction, theOnMouseoverAction, theOnMouseoutAction
  theOnClickAction="" : theOnMouseoverAction="" : theOnMouseoutAction=""
  if IsArray(theEventActions) then
    theOnClickAction=theEventActions(0)
    if UBound(theEventActions)>=1 then theOnMouseoverAction=theEventActions(1)
    if UBound(theEventActions)>=2 then theOnMouseoutAction=theEventActions(2)
  else
    theOnClickAction=theEventActions
  end if
  Dim cc, aa0, aa1, xxo, yyo, dd, ii, nn, pid180
  pid180=3.14159265/180
  cc=GetImgColorIndex(theColor)
  
  aa0=theAngle0
  do while aa0>=360
    aa0=aa0-360
  loop
  do while aa0<0
    aa0=aa0+360
  loop
  aa1=theAngle1
  do while aa1>=360
    aa1=aa1-360
  loop
  do while aa1<0
    aa1=aa1+360
  loop
  xxo=0
  yyo=0
  if aa0<aa1 then
    xxo=sin((aa0+aa1)*pid180/2)*theOffset
    yyo=-cos((aa0+aa1)*pid180/2)*theOffset
  end if  
  if aa0>aa1 then
    xxo=sin((aa0+aa1+360)*pid180/2)*theOffset
    yyo=-cos((aa0+aa1+360)*pid180/2)*theOffset
  end if
  if aa0=aa1 then
    if theAngle0=theAngle1 then Exit Sub
    aa1=aa1+360
  end if 
  Img.ImageFilledArc 0, round(theXCenter+xxo), round(theYCenter+yyo), 2*theRadius, 2*theRadius, aa0+270, aa1+270, cc
  if theTooltipText<>"" or theOnClickAction<>"" or theOnMouseoverAction<>"" or theOnMouseoutAction<>"" then
    if aa0=aa1 then 
      tmpMapData="<area shape=circle coords='" & theXCenter & "," & theYCenter & "," & theRadius & "' "
    else
      tmpMapData="<area shape=polygon coords='" & round(theXCenter+xxo) & "," & round(theYCenter+yyo)
      if aa0<aa1 then
        dd=aa1-aa0
      else 
        dd=aa1-aa0+360
      end if  
      nn=round(dd/20)+1
      for ii=0 to nn
        aa=(aa0+dd*ii/nn) mod 360
        tmpMapData=tmpMapData & "," & round(theXCenter+xxo+sin(aa*pid180)*theRadius)
        tmpMapData=tmpMapData & "," & round(theYCenter+yyo-cos(aa*pid180)*theRadius)
      next
      tmpMapData=tmpMapData & "' "
    end if
    if theTooltipText<>"" then tmpMapData=tmpMapData & " title='" & theTooltipText & "' alt='" & theTooltipText & "'"
    if theOnClickAction<>"" then tmpMapData=tmpMapData & " href='javascript:" & theOnClickAction & "'"
    if theOnMouseoverAction<>"" then tmpMapData=tmpMapData & " onMouseover='" & theOnMouseoverAction & "'"
    if theOnMouseoutAction<>"" then tmpMapData=tmpMapData & " onMouseout='" & theOnMouseoutAction & "'"
    tmpMapData=tmpMapData & ">" & vbCRLF
    ImgMapData=tmpMapData & ImgMapData
  end if  
End Sub

End Class
%>